<?php get_header(); ?>

<section class="content">

    <div class="container">
        <h1 class="sec-tit text-center">
            <?php single_cat_title(); ?>
        </h1>

        <?php if (have_posts()) : ?>
            <div class="row">
                <?php while (have_posts()) : the_post(); ?>
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="news-items">
                            <div class="img-date">
                                <div class="date">
                                    <div class="text wow fadeInRight"
                                         data-wow-delay=".2">
                                        <i class="fa-solid fa-calendar-days"></i>
                                        <?php echo date('d-m-Y'); ?>
                                    </div>
                                </div>
                                <div class="img">
                                    <?php the_post_thumbnail('full', ['class' => 'img-fluid']); ?>
                                </div>
                            </div>
                            <div class="content">
                                <div class="tit wow fadeInDown"
                                     data-wow-delay=".2">
                                    <?php the_title(); ?>
                                </div>
                                <div class="desc wow fadeInDown"
                                     data-wow-delay=".4">
                                    <?php echo(has_excerpt() ? get_the_excerpt() : get_excerpt('50')) ?>
                                </div>
                                <a class="arrow wow fadeInUp"
                                   href="<?php the_permalink(); ?>"
                                   title="<?php the_title(); ?>">
                                    <?php the_switch_language('<i class="fa-solid fa-arrow-left"></i>',
                                        '<i class="fa-solid fa-arrow-right"></i>') ?>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>
            <?php wp_pagenavi(); ?>
        <?php else : ?>
            <p>
                <?php _e('عذرا ، يتم حاليا إضافة المحتوى', 'm7md') ?>
            </p>
        <?php endif; ?>

    </div>
</section>

<?php get_footer(); ?>
